#include <stdio.h>
#include <string.h>
#include <Node.h>
#include <File.h>
#include <StorageDefs.h>
#include <Message.h>
#include <fs_attr.h>
#include <ByteOrder.h>

int
main (
	int argc,
	char **argv
)
{
	BFile output ;

	if(argc < 2)
		fprintf(stderr, "Usage: %s output-file\n", argv[0]);
	else if(output.SetTo(argv[1], B_WRITE_ONLY|B_CREATE_FILE|B_ERASE_FILE)!=B_OK)
		fprintf(stderr, "Error opening [%s] for writing\n", argv[1]);
	else
	{
	// -- -- -- -- -- --
	// FOR EACH PATHNAME
	// -- -- -- -- -- --
		char inpath[B_PATH_NAME_LENGTH];
		while(gets(inpath) != 0)
		{
			unsigned char len = strlen(inpath);

		// -- -- -- -- -- -- -- -- -- --
		// Convert pathname to a BNode
		// -- -- -- -- -- -- -- -- -- --
			BNode node;
			if(node.SetTo(inpath) != B_OK)
				fprintf(stderr, "Error opening [%s] for reading\n", inpath);
			else
			{
			// -- -- -- -- -- -- -- -- -- -- --
			// Convert attributes to a BMessage
			// -- -- -- -- -- -- -- -- -- -- --
				status_t post;
				attr_info atti[1];
				char name[B_ATTR_NAME_LENGTH];

				BMessage msg('Attr');

				while(node.GetNextAttrName(name) == B_NO_ERROR)
				{
					if( (post = node.GetAttrInfo(name, atti)) != B_NO_ERROR)
						fprintf(stderr,
							"Internal error %x on GetAttrInfo(%s, ..)\n",
							post, name
						);
					else
					{
						char *abuf = new char [atti->size];
						node.ReadAttr(name, atti->type, 0, abuf, atti->size);
						msg.AddData(name, atti->type, abuf, atti->size);
						delete [] abuf;
					}
				}

			// -- -- -- -- -- -- -- -- --
			// Write out
			//	path length
			//	path name
			//	message size (bigendian)
			//	message
			// -- -- -- -- -- -- -- -- --
				output.Write(&len, 1);
				output.Write(inpath, len);

				uint32 bend_fsz = B_HOST_TO_BENDIAN_INT32(msg.FlattenedSize());

				output.Write(&bend_fsz, 4);
				msg.Flatten(&output);
			}
		}
	}

	return 0;
}
